function [omega,pha] = ampcross(fr,level)
% AMPCROSS Computation of amplitude level crossing frequencies
%
%       OMEGA = AMPCROSS(FR,LEVEL)
%
%       Given a frequency response FR, all frequencies for which
%       the amplitude crosses LEVEL are computed.
%
%       [OMEGA,PHA] = AMPCROSS(FR,LEVEL)
%
%       gives the phase at the crossing frequencies.

% Mats Lilja
% LastEditDate : Wed Mar 14 17:11:08 1990
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

w = fr(:,1);
g = fr(:,2);
[omega,pha] = levcross([w abs(g) arg(g)],level);

