function amsh(fr,option)
% AMSH  Show the amplitude of a frequency response in a previous plot.
%
%       amsh(fr,option)
%
%       An amplitude plot is done from the frequency responses in fr using
%       the plotoption option. The argument option is optional.

% Kjell Gustafsson    
% LastEditDate : Wed Mar  7 14:45:44 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if frcheck, return, end

if ~any(size(glob_scale)==[1 4])
  error('No previous amplitude plot');
end;

hold on;
ind = size(fr)*[0;1];
if nargin == 1,
  if glob_hz,
    loglog(fr(:,1)/(2*pi),abs(fr(:,2:ind)));
  else
    loglog(fr(:,1),abs(fr(:,2:ind)));
  end
elseif nargin == 2,
  if glob_hz,
    loglog(fr(:,1)/(2*pi),abs(fr(:,2:ind)),option);
  else
    loglog(fr(:,1),abs(fr(:,2:ind)),option);
  end;
end;
hold off;
