function phase = arg(G)
% ARG   Calculate the argument of a complex vector (or vectors). 
%
%       PHASE = ARG(G)
%
%       Compute the argument of each column vector in the complex matrix G.
%       The argument is given in degrees and an attempt is done to keep
%       it continuous over the transitions at 180 and -180 degrees.

% Mats Lilja
% LastEditDate : Mon Mar  4 10:16:44 1991
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[nrows,ncols] = size(G);
for j = 1:ncols,
  ph = imag(log(G(:,j)));
  dph = diff(ph);
  for i = find(abs(dph) > 3.2)',
    ph(i+1:nrows) = ph(i+1:nrows) - 2*pi*sign(dph(i));
  end;
  phase(:,j) = ph*180/pi;
end;
