function bopl(fr1,fr2,fr3,fr4,scale)
% BOPL  Plot a bode plot.
%
%       bopl(fr1,fr2,fr3,fr4,scale)
%
%       A bode plot is done from the frequency responses in fr1 - fr4. 
%       The arguments fr2 - fr4 are optional. fr1 - fr4 is allowed to have
%       different number of data points and columns.
%
%	The optional argument scale is used to affect the scaling of the 
%       plot. It takes the form [wmin wmax amin amax phmin phmax]. wmin, 
%       wmax, amin and amax are given in 10-logarithm, i.e. amin = -1, 
%       amax = 2 corresponds to an amplitude scale from 0.1 to 100. 
%       scale can be used even if fr2 - fr4 are omitted.
%
%       The scales of the amplitude and the phase plot are stored in 
%       the variable glob_scale. which must be declared as global. The
%	scales are used to be able to draw consecutive plots (using BOSH) 
%	in the same diagram.
%
%       The frequency axis will be marked in Hz if the global variable
%	glob_hz has a value differing from 0.

% Kjell Gustafsson    
% LastEditDate : Wed Mar  7 14:46:48 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%%%%%if frcheck, return, end
global glob_hz;
global glob_scale;

if nargin~=5
  scale = eval(['fr' int2str(nargin)]);
end
scaleinfo = all(size(scale) == [1 6]);

ind = sprintf('(:,2:%g)',size(fr1)*[0;1]);
if glob_hz,
  plotamp = ['loglog(fr1(:,1)/(2*pi),abs(fr1' ind ')'];
  plotpha = ['semilogx(fr1(:,1)/(2*pi),arg(fr1' ind ')'];
else
  plotamp = ['loglog(fr1(:,1),abs(fr1' ind ')'];
  plotpha = ['semilogx(fr1(:,1),arg(fr1' ind ')'];
end

for k=2:nargin-scaleinfo,
  kstr = int2str(k);
  eval(['ind = sprintf(''(:,2:%g)'',size(fr' kstr ')*[0;1]);'])
  if glob_hz,
    plotamp = [plotamp ',fr' kstr '(:,1)/(2*pi),abs(fr' kstr ind ')'];
    plotpha = [plotpha ',fr' kstr '(:,1)/(2*pi),arg(fr' kstr ind ')'];
  else
    plotamp = [plotamp ',fr' kstr '(:,1),abs(fr' kstr ind ')'];
    plotpha = [plotpha ',fr' kstr '(:,1),arg(fr' kstr ind ')'];
  end
end
plotamp = [plotamp ');'];
plotpha = [plotpha ');'];

clf;
subplot(211)
if scaleinfo, axis(scale(1,1:4)); end
eval(plotamp);
glob_scale = axis;
if ~scaleinfo, axis; end
ylabel('Magnitude');

subplot(212);
if scaleinfo, axis(scale(1,[1,2,5,6])); end
eval(plotpha);
glob_scale = [glob_scale; axis];
if ~scaleinfo, axis; end
ylabel('Phase [deg]');

if glob_hz,
  xlabel('Frequency [Hz]');
else
  xlabel('Frequency [rad/s]');
end

subplot(211);   % To make `title' appear at the top

