function bosh(fr,option)
% BOSH  Show a bode plot in a previously drawn bode diagram.
%
%       bosh(fr,option)
%
%       A bode plot is done from the frequency responses in fr using
%       plotoption option. The argument option is optional.
%
%       The scales of the amplitude and the phaseplot are taken from the
%       variable glob_scale. This variable is assumed having been declared 
%	as global. 

% Kjell Gustafsson    
% LastEditDate : Wed Mar  7 14:46:57 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%%%if frcheck, return, end
global glob_hz;
global glob_scale;

if ~all(size(glob_scale)==[2 4])
  error('No previous Bode plot');
end

ind = size(fr)*[0;1];

subplot(211);
%%%axis(glob_scale(1,:));
hold on;

if nargin == 1,
  if glob_hz,
    loglog(fr(:,1)/(2*pi),abs(fr(:,2:ind)));
  else
    loglog(fr(:,1),abs(fr(:,2:ind)));
  end
elseif nargin == 2,
  if glob_hz,
    loglog(fr(:,1)/(2*pi),abs(fr(:,2:ind)),option);
  else
    loglog(fr(:,1),abs(fr(:,2:ind)),option);
  end;
end;

subplot(212);
%%%axis(glob_scale(2,:));
hold on;

if nargin == 1,
  if glob_hz,
    semilogx(fr(:,1)/(2*pi),arg(fr(:,2:ind)));
  else
    semilogx(fr(:,1),arg(fr(:,2:ind)));
  end
elseif nargin == 2,
  if glob_hz,
    semilogx(fr(:,1)/(2*pi),arg(fr(:,2:ind)),option);
  else
    semilogx(fr(:,1),arg(fr(:,2:ind)),option);
  end;
end;
axis;

hold off;

subplot(211)   % To make `title' appear at the top
