function evpl(gp,gfb,gff,gl,gn,gz,scale)
% EVPL	plots different frequency responses to evaluate a closed loop system
%
%       evpl(gp,gfb,gff,gl,gn,gz,scale)
%       evpl(gp,gfb,gff,gl,gn,scale)
%       evpl(gp,gfb,gff,gl,scale)
%       evpl(gp,gfb,gff,scale)
%
%       Three plots depicting the transfer functions from r to y (or z), from
%       l to y (or z), and from n to u are plotted. The fourth plot shows
%       a measure of how much multiplicative uncertainty the loop may sustain
%       without becoming unstable.
%
%       The noise and load disturbance inputs can be weighted by supplying
%       gl and/or gn. A nonempty gz tells that the evaluation should be done
%	using z rather than y. gl, gn, and gz are all optional. The value []
%       is interpreted as 1.
%
%	The optional argument scale is used to affect the scaling of the 
%       plots. It takes the form [wmin wmax amin amax]. wmin, 
%       wmax, amin and amax are given in 10-logarithm, i.e. amin = -1, 
%       amax = 2 corresponds to an amplitude scale from 0.1 to 100. scale 
%       can also consist of four rows. Each individual row is then used for
%       its corresponding plot.
%
%       The scales of the plots are stored in the variable glob_scale, 
%	which must be declared as global. The scales are used to be able 
%	to draw consecutive plots (using EVSH) in the same diagram.
%
%       The frequency axis will be marked in Hz if the global variable
%	glob_hz has a value differing from 0.
%	
%
%                             | l    
%                             |     
%                             v    
%                          -------       --------
%                          |     |       |      |           z
%                          | Gl  |   --->|  Gz  |-------------
%                          |     |   |   |      |
%                          -------   |   --------
%                             |      |
%              ---------      |      |   ---------
%         r    |       |      v   u  |   |       |          y
%         ---->|  Gff  |----->+--------->|  Gp   |------------
%              |       |      ^          |       |      |
%              ---------      |          ---------      |
%                             |                         |
%                             |          ---------      |    ---------     
%                             |          |       |      v    |       |   n 
%                             -----------| -Gfb  |<-----+<---|  Gn   |<--- 
%                                        |       |           |       |     
%                                        ---------           ---------     

% Kjell Gustafsson
% LastEditDate : Wed Mar  7 14:47:19 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if frcheck, return, end

if nargin==7
  nogl = all(size(gl)==[0 0]);
  nogn = all(size(gn)==[0 0]);
  nogz = all(size(gz)==[0 0]);
elseif nargin==6
  nogl = all(size(gl)==[0 0]);
  nogn = all(size(gn)==[0 0]);
  if size(gz)==[1 4] | size(gz)==[4 4]
    nogz = 1;
    scale = gz;
  else
    nogz = all(size(gz)==[0 0]);
    scale = [];
  end
elseif nargin==5
  nogl = all(size(gl)==[0 0]);
  if size(gn)==[1 4] | size(gn)==[4 4]
    nogn = 1;
    scale = gn;
  else
    nogn = all(size(gn)==[0 0]);
    scale = [];
  end
  nogz = 1;
elseif nargin==4
  if size(gl)==[1 4] | size(gl)==[4 4]
    nogl = 1;
    scale = gl;
  else
    nogl = all(size(gl)==[0 0]);
    scale = [];
  end
  nogn = 1;
  nogz = 1;
else
  nogl = 1;
  nogn = 1;
  nogz = 1;
  scale = [];
end

if size(scale)==[0 0]
  scaleinfo = 0;
else
  scaleinfo = 1;
  if size(scale)==[1 4]
    scale = [scale; scale; scale; scale];
  end
end

gloop = fclos(fmul(gp,gfb));

if nogz
  gzr = fmul(gloop,fdiv(gff,gfb));
else
  gzr = fmul(fmul(gloop,fdiv(gff,gfb)),fdiv(gz,gp));
end

if nogl
  gzl = fdiv(gzr,gff);
else
  gzl = fmul(gzr,fdiv(gl,gff));
end

% The following calculations have the wrong sign, but since we only
% will plot the magnitude that does not matter.

if nogn
  gun = fdiv(gloop,gp);
else
  gun = fmul(gloop,fdiv(gn,gp));
end

grob = finv(gloop);

subplot;

subplot(221);
ind = size(gzr)*[0;1];
if scaleinfo, axis(scale(1,:)); end
if glob_hz
  loglog(gzr(:,1)/(2*pi),abs(gzr(:,2:ind)));
else
  loglog(gzr(:,1),abs(gzr(:,2:ind)));
end
glob_scale = axis;
if ~scaleinfo, axis; end

if glob_hz
  xlabel('Frequency [Hz]');
else
  xlabel('Frequency [rad/s]');
end
ylabel('Magnitude');
if nogz
  title('r --> y');
else
  title('r --> z');
end

subplot(222);
ind = size(gzl)*[0;1];
if scaleinfo, axis(scale(2,:)); end
if glob_hz
  loglog(gzl(:,1)/(2*pi),abs(gzl(:,2:ind)));
else
  loglog(gzl(:,1),abs(gzl(:,2:ind)));
end
glob_scale = [glob_scale; axis];
if ~scaleinfo, axis; end

if glob_hz
  xlabel('Frequency [Hz]');
else
  xlabel('Frequency [rad/s]');
end
ylabel('Magnitude');
if nogz
  title('l --> y');
else
  title('l --> z');
end

subplot(223);
ind = size(gun)*[0;1];
if scaleinfo, axis(scale(3,:)); end
if glob_hz
  loglog(gun(:,1)/(2*pi),abs(gun(:,2:ind)));
else
  loglog(gun(:,1),abs(gun(:,2:ind)));
end
glob_scale = [glob_scale; axis];
if ~scaleinfo, axis; end

if glob_hz
  xlabel('Frequency [Hz]');
else
  xlabel('Frequency [rad/s]');
end
ylabel('Magnitude');
title('n --> u');

subplot(224);
ind = size(grob)*[0;1];
if scaleinfo, axis(scale(4,:)); end
if glob_hz
  loglog(grob(:,1)/(2*pi),abs(grob(:,2:ind)));
else
  loglog(grob(:,1),abs(grob(:,2:ind)));
end
glob_scale = [glob_scale; axis];
if ~scaleinfo, axis; end

if glob_hz
  xlabel('Frequency [Hz]');
else
  xlabel('Frequency [rad/s]');
end
ylabel('Magnitude');
title('Robustness to mult uncert');
