function [gm,phm,wgm,wphm] = fmarg(fr)
%FMARG	Gain margin, phase margin, and associated frequencies
%
%       [gm,phm,wgm,wphm] = fmarg(fr)
%
%	Calculates the gain and phase margins for the frequency responses 
%       in fr. Each row in the output arguments corresponds to one column
%       in fr. An undefined gain och phase margin is represented with NaN.

% Kjell Gustafsson
% LastEditDate : Mon Jun 25 17:35:47 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

gm = [];
phm = [];
wgm = [];
wphm = [];

for k=2:size(fr)*[0;1]
  [wphmtmp,phmtmp] = ampcross([fr(:,1) fr(:,k)],1);
  [wgmtmp,gmtmp] = phacross([fr(:,1) fr(:,k)],-180);
  if size(gmtmp)==[0 0], gmtmp = NaN; end
  if size(phmtmp)==[0 0], phmtmp = NaN; end
  if size(wgmtmp)==[0 0], wgmtmp = NaN; end
  if size(wphmtmp)==[0 0], wphmtmp = NaN; end
  gm = [gm; 1/gmtmp];
  phm = [phm; 180+phmtmp];
  wgm = [wgm; wgmtmp];
  wphm = [wphm; wphmtmp];
end
 
