function [gm,phm,wgm,wphm] = fmargin(fr)
%FMARGIN  Gain margin, phase margin, and associated frequencies
%
%       [gm,phm,wgm,wphm] = fmargin(fr)
%
%	Calculates the gain and phase margins for the frequency responses 
%       in fr. Each row in the output arguments corresponds to one column
%       in fr. An undefined gain och phase margin is represented with NaN.

gm = [];
phm = [];
wgm = [];
wphm = [];

for k=2:size(fr)*[0;1]
  w = fr(:,1);
  g = fr(:,k);
  [wphmtmp,phmtmp] = levkross([w abs(g) arg(g)],1);
  [wgmtmp,gmtmp] = levkross([w arg(g) abs(g)],-180);
  if size(gmtmp)==[0 0], gmtmp = NaN; end
  if size(phmtmp)==[0 0], phmtmp = NaN; end
  if size(wgmtmp)==[0 0], wgmtmp = NaN; end
  if size(wphmtmp)==[0 0], wphmtmp = NaN; end
  gm = [gm; 1/gmtmp];
  phm = [phm; 180+phmtmp];
  wgm = [wgm; wgmtmp];
  wphm = [wphm; wphmtmp];
end
 
