function fr3dplot(Num, Den, scale, limit, n);
% fr3dplot(Num, Den, scale, limit, n)
% fr3dplot(Num, Den, scale, limit)
% fr3dplot(Num, Den, scale)
if nargin<5
  n = 200;
end;
if nargin<4
  limit = 10;
end;
x = [scale(1):(scale(2)-scale(1))/n:scale(2)];
y = [scale(3):(scale(4)-scale(3))/n:scale(4)];
xx = ones(n+1,1)*x;
yy = y'*ones(1,n+1);
absg = abs(polyval(Num,xx+i*yy)./polyval(Den,xx+i*yy));
limg = min(absg, limit);
mesh(x, y, limg);

