function fr=frcss(a,b,c,d,tau,lgw1,lgw2,n)
% FRCSS Computes the frequency response of a continuous time MIMO state 
%	space system.
%
%       fr = frcss(a,b,c,d,tau,lgw1,lgw2,n)
%       fr = frcss(a,b,c,d,tau,wvec)
%
%       The value of G(s) = ( c (sI-a)^(-1)  b + d )*exp(-tau*s) is calculated 
%	either for the frequencies in wvec [rad/s] or for n logarithmically 
%	spaced frequency points [rad/s] between 10^lgw1 and 10^lgw2. The 
%	argument n is optional with default value 50.
%
%       The output fr takes the form  [  w   G11(iw) G12(iw) ... Gmn(iw) ]
%       with Gij as the transfer function from input j to output i.

% Michael Lundh (original)    
% Kjell Gustafsson (revision)
% LastEditDate : Thu Mar  8 16:59:06 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin==8
  w = logspace(lgw1,lgw2,n);
elseif nargin==7
  w = logspace(lgw1,lgw2);
else 
  w = lgw1(:);
end

i = sqrt(-1);

error(abcdchk(a,b,c,d));
[no,ns] = size(c);
ni = size(b)*[0;1];

% Balance A
[t,a] = balance(a);
b = t \ b;
c = c * t;

% Reduce A to Hessenberg form
[p,a] = hess(a);
c = c*p;

gg = [];
for iu=1:ni
  g = ltifr(a,p'*b(:,iu),i*w);
  g = c*g + diag(d(:,iu)) * ones(no,length(w));
  gg = [gg g.'];
end;

%---- now sorted G11 G21 G31 .. G12 G22 .. .. Gmn  -- modify
fr = [];
for i=1:no
  fr = [fr gg(:,i:no:no*ni)];
end

%---- add time delay
fr = diag(exp(-i*w*tau))*fr; 

fr = [w(:) fr];
