function fr = frd(b,a,tsamp,lgw1,lgw2,n)
% FRD   Computes the frequency response of a discrete time 
%       transfer function.
%
%       fr = frd(b,a,tsamp,lgw1,lgw2,n)
%       fr = frd(b,a,tsamp,lgw1,[],n)
%       fr = frd(b,a,tsamp,lgw1)
%       fr = frd(b,a,tsamp,wvec)
%
%       The value of H(z) = b(z)/a(z) is calculated either for the frequencies
%	in wvec [rad/s] or for n logarithmically spaced frequency points 
%	[rad/s] between 10^lgw1 and 10^lgw2. The argument n is optional with 
%	default value 50. If lgw2 is supplied as an empty matrix or omitted it
%       is taken as half the sampling frequency (pi/tsamp).
%
%    	If b and a contain several rows the frequency response will be
%	calculated for each pair b(i,:) and a(i,:).
%
%       The output fr takes the form 
%	[ w  H1(exp(iw*tsamp)) H2(exp(iw*tsamp)) ... ] where Hi corresponds
% 	to row i of a and b.

% Kjell Gustafsson     
% LastEditDate : Wed Mar  7 14:50:04 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

i = sqrt(-1);

if nargin==6
  if size(lgw2)~=[0 0]
    w = logspace(lgw1,lgw2,n)';
  else
    w = logspace(lgw1,log10(pi/tsamp),n)';
  end
elseif nargin==5
  w = logspace(lgw1,lgw2)';
elseif length(lgw1)==1
  w = logspace(lgw1,log10(pi/tsamp))';
else
  w = lgw1(:);
end

fr = [w gval(b,a,zeros(size(a)*[1;0],1),exp(i*w*tsamp))];
