function fr=frdss(a,b,c,d,tsamp,lgw1,lgw2,n)
% FRDSS Computes the frequency response of a discrete time MIMO state 
%	space system.
%
%       fr = frdss(a,b,c,d,tsamp,lgw1,lgw2,n)
%       fr = frdss(a,b,c,d,tsamp,lgw1,[],n)
%       fr = frdss(a,b,c,d,tsamp,lgw1)
%       fr = frdss(a,b,c,d,tsamp,wvec)
%
%       The value of H(q) = c (qI-a)^(-1) b + d is calculated either for the 
%	frequencies in wvec [rad/s] or for n logarithmically spaced frequency 
%	points [rad/s] between 10^lgw1 and 10^lgw2. The argument n is optional
%	with default value 50. If lgw2 is supplied as an empty matrix or 
%	omitted it is taken as half the sampling frequency (pi/tsamp).
%
%       The output fr takes the form 
%	[ w  H11(exp(iw*tsamp)) H12(exp(iw*tsamp)) ... Hmn(exp(iw*tsamp)] 
%	where Hij corresponds to the transfer function from input j to 
%       output i.

% Michael Lundh (original)
% Kjell Gustafsson (revision)
% LastEditDate : Wed Mar  7 14:50:30 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin==8
  if size(lgw2)~=[0 0]
    w = logspace(lgw1,lgw2,n)';
  else
    w = logspace(lgw1,log10(pi/tsamp),n)';
  end
elseif nargin==7
  w = logspace(lgw1,lgw2)';
elseif length(lgw1)==1
  w = logspace(lgw1,log10(pi/tsamp))';
else
  w = lgw1(:);
end

eiwh = exp(sqrt(-1)*w*tsamp);

error(abcdchk(a,b,c,d));
[no,ns] = size(c);
ni      = size(b)*[0;1];

% Balance A
[t,a] = balance(a);
b = t \ b;
c = c * t;

% Reduce A to Hessenberg form
[p,a] = hess(a);
c     = c*p;

gg = [];
for iu=1:ni
  g = ltifr(a,p'*b(:,iu),eiwh);
  g = c*g + diag(d(:,iu)) * ones(no,length(w));
  gg = [gg g.'];
end;

%---- now sorted G11 G21 G31 .. G12 G22 .. .. Gmn  -- MODIFY
fr = w(:);
for i=1:no
  fr = [fr gg(:,i:no:no*ni)];
end
