function fr = fsub(fr1,fr2)
% FSUB	Subtracts two frequency responses (parallel connection with opposite
%	sign of two systems).
%
%	fr = fsub(fr1,fr2)
%
%       Each frequency response in fr2 is subtracted from the corresponding
%       response in fr1 (fr1-fr2). If fr1 or fr2 contain only one response it 
%       is used for each response in the other variable.

% Kjell Gustafsson
% LastEditDate : Wed Mar  7 14:52:02 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

[n1,m1] = size(fr1);
[n2,m2] = size(fr2);

if n1~=n2
  error('Not the same number of frequency points.');
elseif any(fr1(:,1)-fr2(:,1)>eps)
  error('Different frequency points.');
elseif m1==2
  fr = [fr1(:,1) fr1(:,2)*ones(1,m2-1)-fr2(:,2:m2)];
elseif m2==2
  fr = [fr1(:,1) fr1(:,2:m1)-fr2(:,2)*ones(1,m1-1)];
elseif m1==m2
  fr = [fr1(:,1) fr1(:,2:m1)-fr2(:,2:m2)];
else
  error('Inconsistent number of columns in fr1 and fr2');
end
