function [xc,zc]=levkross(xyz,yc)
%
[nr,nc] = size(xyz);
x = xyz(:,1);
y = xyz(:,2);
z = xyz(:,3);
adsy = abs(diff(sign(y-yc)));
ind = find(adsy > 0);
n = length(ind);
nz = 1:(nc-2);
for j=1:n
  k = ind(j);
  x0 = x(k); x1 = x(k+1);
  y0 = y(k); y1 = y(k+1);
  z0 = z(k,nz); z1 = z(k+1,nz);
  xc(j,1) = x0 + (x1-x0)*(yc-y0)/(y1-y0);
  zc(j,nz) = z0 + (z1-z0)*(yc-y0)/(y1-y0);
end;

