function nigrid(mp)
% NiGRID Plot grid and mark the mp-circles in a Nichols plot.
%
%       nigrid(mp)
%
%       The argument mp decides which mp-circles to draw. If mp is not
%       supplied the circle corresponding to log10(|G|) = [-0.5 -0.2
%       -0.1 -0.05 0 0.05 0.1 0.2 0.5] are drawn.

% Kjell Gustafsson
% LastEditDate : Wed Mar  7 14:52:43 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

niscale = axis;

hold on;
grid;

phtemp = niscale(1);
if nargin==0,
  mp = [10^0.5 10^0.2 10^0.1 10^0.05 1 10^(-0.05)..
    10^(-0.1) 10^(-0.2) 10^(-0.5)];
end;
mpval = mpcirc(mp,100);
mpabs = abs(mpval);
mparg = arg(mpval);
mparg = mparg - 360*ones(100,1)*(max(mparg)>0);
while phtemp<niscale(2)+359,
  semilogy(mparg+ceil(phtemp/360)*360,mpabs,'-w');
  phtemp = phtemp+360;
end
hold off;
