function nipl(fr1,fr2,fr3,fr4,wmark,scale)
% NIPL	Plot a Nichols plot.
%
%       nipl(fr1,fr2,fr3,fr4,wmark,scale)
%       nipl(fr1,fr2,fr3,fr4,[],scale)
%       nipl(fr1,fr2,fr3,fr4,wmark)
%       nipl(fr1,fr2,fr3,fr4)
%
%       A Nichols plot is done from the frequency responses in fr1 - fr4. 
%       The arguments fr2 - fr4 are optional. fr1 - fr4 is allowed to have
%       different number of data points and columns.
%
%       The frequency points in wmark are marked in the plot. If wmark is 
%       omitted or has the value [] no marking is done. If wmark equals
%       '125' then the 1, 2 and 5 frequency points in each decade are marked 
%       with +, *, and o, respectively. Due to numerics it may happen that 
%       end points are not marked. If the global variable glob_hz has a value 
%       differing from 0, then the marked points will be in [Hz] while in 
%       [rad/s] otherwise. The mp-circle corresponding to log10(|G|) = 0.1 
%       is plotted.
%
%       The scales of the plot can be affected by supplying the argument
%       scale. It takes the form [phmin phmax amin amax]. amin and amax are
%       given in 10-logarithm, i.e. amin = -1, amax = 2 corresponds to an
%       amplitude scale from 0.1 to 100.
%
%       To draw consecutive plots in the same diagram use NISH.

% Kjell Gustafsson    
% LastEditDate : Tue Apr 17 08:24:49 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%%%if frcheck, return, end
global glob_hz;
global glob_scale;

% Determine if the scale and/or mark argument is present

if nargin==1
  scaleinfo = 0;
  markinfo = 0;
  markarg = 0;
  wmark = [];
else
  if nargin<6
    if nargin==5
      scale = wmark;
    else
      scale = eval(['fr' int2str(nargin)]);
    end
    wmark = eval(['fr' int2str(nargin-1)]);
  end
  if min(size(wmark))>1
    scaleinfo = 0;
    wmark = scale;
    wsize = size(wmark);
    if min(wsize)==1
      markinfo = 1;
      markarg = 1;
    elseif wsize==[0 0]
      markinfo = 0;
      markarg = 1;
    else
      markinfo = 0;
      markarg = 0;
    end
  else
    if size(scale)==[1 4]
      scaleinfo = 1;
    else
      error('Incorrect scale argument');
    end
    markarg = 1;
    if size(wmark)==[0 0]
      markinfo = 0;
    else
      markinfo = 1;
    end
  end
end

% Construct a command that calculates which decades a frequency response spans

if glob_hz,
  decstr = ['dec = 2*pi*'..
    'exp(log(10)*(floor(log10(wmin/(2*pi))):ceil(log10(wmax/(2*pi))))'');'];
else
  decstr = 'dec = exp(log(10)*(floor(log10(wmin)):ceil(log10(wmax)))'');';
end


% Calulate the markings for the first response. The interpolation has to be
% done on the phase-amplitude data to handle phase wrap correctly. 
% Unfortunately this makes the code rather involved.

ind1 = size(fr1)*[0;1];
ind2 = 2*(ind1-1);
f = [fr1(:,1) abs(fr1(:,2:ind1)) arg(fr1(:,2:ind1))];

if markinfo
  if ~isstr(wmark)
    ptemp = table1(f,wmark);
    if size(ptemp)~=[0 0]
      pt1 = ptemp(:,1:ind1-1);
      pt2 = ptemp(:,ind1:ind2);
      p = [pt1(:) pt2(:)];
    else
      p = [];
    end
  else
    wmin = min(f(:,1));
    wmax = max(f(:,1));
    eval(decstr);
    w1 = dec;
    w2 = 2*dec;
    w5 = 5*dec;
    ptemp = table1(f,w1(find((w1 >= wmin) & (w1 <= wmax))));
    if size(ptemp)~=[0 0]
      pt1 = ptemp(:,1:ind1-1);
      pt2 = ptemp(:,ind1:ind2);
      p1 = [pt1(:) pt2(:)];
    else
      p1 = [];
    end
    ptemp = table1(f,w2(find((w2 >= wmin) & (w2 <= wmax))));
    if size(ptemp)~=[0 0]
      pt1 = ptemp(:,1:ind1-1);
      pt2 = ptemp(:,ind1:ind2);
      p2 = [pt1(:) pt2(:)];
    else
      p2 = [];
    end
    ptemp = table1(f,w5(find((w5 >= wmin) & (w5 <= wmax))));
    if size(ptemp)~=[0 0]
      pt1 = ptemp(:,1:ind1-1);
      pt2 = ptemp(:,ind1:ind2);
      p5 = [pt1(:) pt2(:)];
    else
      p5 = [];
    end
  end
end

f1 = f;
istr1 = sprintf('(:,2:%g)',ind1);
istr2 = sprintf('(:,%g+1:%g+1)',ind1,ind2);
plotnich = ['semilogy(f1' istr2 ',f1' istr1 ];

% Loop to handle the rest of the responses similar to the first one

for k=2:nargin-scaleinfo-markarg,
  kstr = int2str(k);
  f = eval(['fr' kstr]);
  ind1 = size(f)*[0;1];
  ind2 = 2*(ind1-1);
  f = [f(:,1) abs(f(:,2:ind1)) arg(f(:,2:ind1))];

  if markinfo
    if ~isstr(wmark)
      ptemp = table1(f,wmark);
      if size(ptemp)~=[0 0]
	pt1 = ptemp(:,1:ind1-1);
	pt2 = ptemp(:,ind1:ind2);
	p = [p; pt1(:) pt2(:)];
      end
    else
      wmin = min(f(:,1));
      wmax = max(f(:,1));
      eval(decstr);
      w1 = dec;
      w2 = 2*dec;
      w5 = 5*dec;
      ptemp = table1(f,w1(find((w1 >= wmin) & (w1 <= wmax))));
      if size(ptemp)~=[0 0]
	pt1 = ptemp(:,1:ind1-1);
	pt2 = ptemp(:,ind1:ind2);
	p1 = [p1; pt1(:) pt2(:)];
      end
      ptemp = table1(f,w2(find((w2 >= wmin) & (w2 <= wmax))));
      if size(ptemp)~=[0 0]
	pt1 = ptemp(:,1:ind1-1);
	pt2 = ptemp(:,ind1:ind2);
	p2 = [p2; pt1(:) pt2(:)];
      end
      ptemp = table1(f,w5(find((w5 >= wmin) & (w5 <= wmax))));
      if size(ptemp)~=[0 0]
	pt1 = ptemp(:,1:ind1-1);
	pt2 = ptemp(:,ind1:ind2);
	p5 = [p5; pt1(:) pt2(:)];
      end
    end
  end

  eval(['f' kstr ' = f;']);
  istr1 = sprintf('(:,2:%g)',ind1);
  istr2 = sprintf('(:,%g+1:%g+1)',ind1,ind2);

  plotnich = [plotnich ',f' kstr istr2 ',f' kstr istr1];
end

plotnich = [plotnich ');'];

subplot(111)
if scaleinfo, axis(scale); end
eval(plotnich);

hold on;
if markinfo
  if ~isstr(wmark)
    semilogy(p(:,2),p(:,1),'xw')
  else
    semilogy(p1(:,2),p1(:,1),'+w')
    semilogy(p2(:,2),p2(:,1),'*w')
    semilogy(p5(:,2),p5(:,1),'ow')
  end
end
hold off;

% Plot mp-circle

niscale = axis;
mp = mpcirc(10^0.1,100);
mpabs = abs(mp);
mparg = arg(mp);
mparg = mparg - 360*ones(100,1)*(max(mparg)>0);
phtemp = niscale(1);
hold on;
while phtemp<niscale(2)+359,
  semilogy(mparg+ceil(phtemp/360)*360,mpabs,'-w',-180+ceil(phtemp/360)*360,1,'+w');
  phtemp = phtemp+360;
end
hold off;

ylabel('Magnitude');
xlabel('Phase [deg]');
if isstr(wmark)
  if glob_hz,
    text(0.96,0.89,'Hz','sc');
  else
    text(0.96,0.89,'rad','sc');
  end
  text(0.96,0.86,'1 +','sc');
  text(0.96,0.83,'2 *','sc');
  text(0.96,0.80,'5 o','sc');
end
