function nish(fr,wmark,option)
% NISH	Show a Nichols plot in a previously drawn Nichols diagram.
%
%       nish(fr,wmark,option)
%       nish(fr,[],option)
%       nish(fr,wmark)
%       nish(fr)
%
%       A Nichols plot is done from the frequency responses in fr using
%       plotoption option. The argument option is optional. 
%
%       The frequency points in wmark are marked in the plot. If wmark is 
%       omitted or has the value [] no marking is done. If wmark equals
%       '125' then the 1, 2 and 5 frequency points in each decade are marked 
%       with +, *, and o, respectively. Due to numerics it may happen that 
%       end points are not marked. If the global variable glob_hz has a value 
%       differing from 0, then the marked points will be in [Hz] while in 
%       [rad/s] otherwise.

% Kjell Gustafsson    
% LastEditDate : Fri Mar 30 08:27:01 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if frcheck, return, end

if nargin>1
  markinfo = size(wmark)~=[0 0];
else
  markinfo = 0;
end

% Calulate the markings. The interpolation has to be done on the 
% phase-amplitude data to handle phase wrap correctly. Unfortunately 
% this makes the code rather involved.

ind1 = size(fr)*[0;1];
ind2 = 2*(ind1-1);
f = [fr(:,1) abs(fr(:,2:ind1)) arg(fr(:,2:ind1))];

if markinfo
  if ~isstr(wmark)
    ptemp = table1(f,wmark);
    if size(ptemp)~=[0 0]
      pt1 = ptemp(:,1:ind1-1);
      pt2 = ptemp(:,ind1:ind2);
      p = [pt1(:) pt2(:)];
    else
      p = [];
    end
  else
    wmin = min(f(:,1));
    wmax = max(f(:,1));
    if glob_hz,
      dec = 2*pi*..
	exp(log(10)*(floor(log10(wmin/(2*pi))):ceil(log10(wmax/(2*pi))))');
    else
      dec = exp(log(10)*(floor(log10(wmin)):ceil(log10(wmax)))');
    end
    w1 = dec;
    w2 = 2*dec;
    w5 = 5*dec;
    ptemp = table1(f,w1(find((w1 >= wmin) & (w1 <= wmax))));
    if size(ptemp)~=[0 0]
      pt1 = ptemp(:,1:ind1-1);
      pt2 = ptemp(:,ind1:ind2);
      p1 = [pt1(:) pt2(:)];
    else
      p1 = [];
    end
    ptemp = table1(f,w2(find((w2 >= wmin) & (w2 <= wmax))));
    if size(ptemp)~=[0 0]
      pt1 = ptemp(:,1:ind1-1);
      pt2 = ptemp(:,ind1:ind2);
      p2 = [pt1(:) pt2(:)];
    else
      p2 = [];
    end
    ptemp = table1(f,w5(find((w5 >= wmin) & (w5 <= wmax))));
    if size(ptemp)~=[0 0]
      pt1 = ptemp(:,1:ind1-1);
      pt2 = ptemp(:,ind1:ind2);
      p5 = [pt1(:) pt2(:)];
    else
      p5 = [];
    end
  end
end

hold on;
if nargin~=3
  semilogy(f(:,ind1+1:ind2+1),f(:,2:ind1));
else
  semilogy(f(:,ind1+1:ind2+1),f(:,2:ind1),option);
end
if markinfo
  if ~isstr(wmark)
    semilogy(p(:,2),p(:,1),'xw')
  else
    semilogy(p1(:,2),p1(:,1),'+w')
    semilogy(p2(:,2),p2(:,1),'*w')
    semilogy(p5(:,2),p5(:,1),'ow')
  end
end
hold off;
