function [z] = nycontour(lgr,lgR,nw)
% z = nycontour(lgr,lgR,nw)
% Computes a vector containing values of the nyquist contour
% in the complex plane. "lgr" and "lgR" are the 10log's of the radii
% of the small and the large semi-circles. "nw" is number of
% points on the positive imaginary axis.
i = sqrt(-1);
if length(nw) == 1,
  w = logspace(lgr,lgR,nw)';
else
  w = nw(:);
end;
r = 10^lgr;
R = 10^lgR;
phi = (-pi/2:pi/50:1.01*pi/2)';
z = [i*w ; R*exp(-i*phi) ; i*sort(-w) ; r*exp(i*phi)];
