function nypl(fr1,fr2,fr3,fr4,wmark,scale)
% NYPL	Plot a Nyquist plot.
%
%       nypl(fr1,fr2,fr3,fr4,wmark,scale)
%       nypl(fr1,fr2,fr3,fr4,[],scale)
%       nypl(fr1,fr2,fr3,fr4,wmark)
%       nypl(fr1,fr2,fr3,fr4)
%
%       A Nyquist plot is done from the frequency responses in fr1 - fr4. 
%       The arguments fr2 - fr4 are optional. fr1 - fr4 is allowed to have
%       different number of data points and columns.
%
%       The frequency points in wmark are marked in the plot. If wmark is 
%       omitted or has the value [] no marking is done. If wmark equals
%       '125' then the 1, 2 and 5 frequency points in each decade are marked 
%       with +, *, and o, respectively. Due to numerics it may happen that 
%       end points are not marked. If the global variable glob_hz has a value 
%       differing from 0, then the marked points will be in [Hz] while in 
%       [rad/s] otherwise.
%
%       By default the plot scale is chosen as [-2 1 -2 1], i.e. a square
%       with the -1 point in the center. The scaling can be affected by
%       supplying the argument scale. scale may take the following forms
%       [xmin xmax ymin ymax],
%	[xmin xmax ymin]     interpreted as [xmin xmax ymin ymin+(xmax-xmin)],
%	[xmin xmax]          interpreted as [xmin xmax xmin xmax]
%	[xmin]               interpreted as [-xmin xmin -xmin xmin]
%
%       To draw consecutive plots in the same diagram use NYSH.

% Kjell Gustafsson    
% LastEditDate : Thu May  3 16:12:32 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%%%%%if frcheck, return, end

% Determine if the scale and/or mark argument is present

global glob_hz;
global glob_scale;

if nargin==1
  scaleinfo = 0;
  markinfo = 0;
  markarg = 0;
  wmark = [];
else
  if nargin<6
    if nargin==5
      scale = wmark;
    else
      scale = eval(['fr' int2str(nargin)]);
    end
    wmark = eval(['fr' int2str(nargin-1)]);
  end
  if min(size(wmark))>1
    scaleinfo = 0;
    wmark = scale;
    wsize = size(wmark);
    if min(wsize)==1
      markinfo = 1;
      markarg = 1;
    elseif wsize==[0 0]
      markinfo = 0;
      markarg = 1;
    else
      markinfo = 0;
      markarg = 0;
    end
  else
    scaleinfo = 1;
    [ns,ms] = size(scale);
    if ns==1,
      if ms==1,
	scale = [-scale scale -scale scale];
      elseif ms==2,
	scale = [scale scale];
      elseif ms==3,
	scale = [scale scale(3)+(scale(2)-scale(1))];
      elseif ms==4,
	scale = scale;
      else 
	error('Incorrect scale argument');
      end
    else
      error('Incorrect scale argument');
    end  
    markarg = 1;
    if size(wmark)==[0 0]
      markinfo = 0;
    else
      markinfo = 1;
    end
  end
end

% Construct a command that calculates which decades a frequency response spans

if glob_hz,
  decstr = ['dec = 2*pi*'...
    'exp(log(10)*(floor(log10(wmin/(2*pi))):ceil(log10(wmax/(2*pi))))'');'];
else
  decstr = 'dec = exp(log(10)*(floor(log10(wmin)):ceil(log10(wmax)))'');';
end

% Calulate the markings for the first response.

if markinfo
  if ~isstr(wmark)
    ptemp = table1(fr1,wmark);
    if size(ptemp)~=[0 0]
      p = ptemp(:);
    else
      p = [];
    end
  else
    wmin = min(fr1(:,1));
    wmax = max(fr1(:,1));
    eval(decstr);
    w1 = dec;
    w2 = 2*dec;
    w5 = 5*dec;
    ptemp = table1(fr1,w1(find((w1 >= wmin) & (w1 <= wmax))));
    if size(ptemp)~=[0 0]
      p1 = ptemp(:);
    else
      p1 = [];
    end
    ptemp = table1(fr1,w2(find((w2 >= wmin) & (w2 <= wmax))));
    if size(ptemp)~=[0 0]
      p2 = ptemp(:);
    else
      p2 = [];
    end
    ptemp = table1(fr1,w5(find((w5 >= wmin) & (w5 <= wmax))));
    if size(ptemp)~=[0 0]
      p5 = ptemp(:);
    else
      p5 = [];
    end
  end
end

ind = sprintf('(:,2:%g)',size(fr1)*[0;1]);
plotny = ['plot(real(fr1' ind '),imag(fr1' ind ')'];

% Loop to handle the rest of the responses similar to the first one

for k=2:nargin-scaleinfo-markarg,
  kstr = int2str(k);
  f = eval(['fr' kstr]);

  if markinfo
    if ~isstr(wmark)
      ptemp = table1(f,wmark);
      if size(ptemp)~=[0 0]
	p = [p; ptemp(:)];
      end
    else
      wmin = min(f(:,1));
      wmax = max(f(:,1));
      eval(decstr);
      w1 = dec;
      w2 = 2*dec;
      w5 = 5*dec;
      ptemp = table1(f,w1(find((w1 >= wmin) & (w1 <= wmax))));
      if size(ptemp)~=[0 0]
	p1 = [p1; ptemp(:)];
      end
      ptemp = table1(f,w2(find((w2 >= wmin) & (w2 <= wmax))));
      if size(ptemp)~=[0 0]
	p2 = [p2; ptemp(:)];
      end
      ptemp = table1(f,w5(find((w5 >= wmin) & (w5 <= wmax))));
      if size(ptemp)~=[0 0]
	p5 = [p5; ptemp(:)];
      end
    end
  end

  eval(['ind = sprintf(''(:,2:%g)'',size(fr' kstr ')*[0;1]);'])
  plotny = [plotny ',real(fr' kstr ind '),imag(fr' kstr ind ')'];
end

plotny = [plotny ');'];

subplot(111)
axis('square');
if scaleinfo,
  axis(scale); 
else
  axis([-2 1 -2 1]);
end
eval(plotny);

hold on;
if markinfo
  if ~isstr(wmark)
    plot(p,'xr')
  else
    plot(p1,'+r')
    plot(p2,'*r')
    plot(p5,'or')
  end
end

ylabel('Im');
xlabel('Re');
if isstr(wmark)
  if glob_hz,
    text(0.845,0.89,'Hz','sc');
  else
    text(0.845,0.89,'rad/s','sc');
  end
  text(0.845,0.86,'1 +','sc');
  text(0.845,0.83,'2 *','sc');
  text(0.845,0.80,'5 o','sc');
end

hold off;
%%%axis('normal');
%%%%%
if scaleinfo,
  axis(scale); 
else
  axis([-2 1 -2 1]);
end
sca = axis;
hold on;
plot(sca([1 2]),[0 0],'c-');
plot([0 0],sca([3 4]),'c-');
hold off;
axis('square');

