function [omega,amp] = phacross(fr,level)
% PHACROSS Computation of phase level crossing frequencies
%
%       OMEGA = PHACROSS(FR,LEVEL)
%
%       Given a frequency response FR, all frequencies for which
%       the phase crosses LEVEL are computed.
%
%       [OMEGA,AMP] = PHACROSS(FR,LEVEL)
%
%       gives the amplitude at the crossing frequencies.

% Mats Lilja
% LastEditDate : Wed Mar 14 16:55:58 1990
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

w = fr(:,1);
g = fr(:,2);
[omega,amp] = levcross([w arg(g) abs(g)],level);
