function [r,s,t,the_error]=rstdelay(w,b,a,tau,bm,am,taum,ao,nr,ns,r1,s1)
% LSRSTC Fits a continuous time controller to a specified closed
%       loop model given a process model of finite order combined
%       with a time delay tau i.e. G(s)=(B(s)/A(s))exp(-tau s). The calling
%       syntax is given by
%
%       [R,S,T,THE_ERROR]=RSTDELAY(W,B,A,TAU,BM,AM,TAUM,AO,NR,NS,R1,S1)
%
%       The process model is used for generating a frequency response 
%       on the form [w G(iw)] which is used for least squares fitting
%       of controller parameters in a controller structure given by
%       Ru = Tr - Sy.
%       The closed loop system (r --> y) is specified
%       by the transfer function (BM(s)/AM(s))exp(-taum s).
%       For convenience, the polynomial BM is multiplied
%       by a constant factor in order to get a closed loop
%       stationary gain of 1 (i.e. BM(0)/AM(0)=1).
%       Factors to be included in R are specified by the polynomial R1.
%       Similarly, S1 pre-specifies factors of S.
%       Deg R = NR and deg S = NS. The observer polynomial is given by
%       AO (T = const.*AO). If the frequency vector consists of
%       two rows instead of one then the second row will be
%       interpreted as weighting in the least squares criterion.
%       Default weighting is unity weighting
%       while R1 and S1 both defaults to 1.
%       The magnitude of the (weighted) closed loop transfer
%       function error is given by THE_ERROR.

% Mats Lilja
% LastEditDate : Thu Jul 19 18:20:48 1990
% Copyright (c) 1990 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

nw = size(w)*[0;1];
i = sqrt(-1);
if size(w)*[1;0] > 1,
  weighting = w(2,:);
  z = i*w(1,:);
else,
  weighting = ones(1,nw);
  z = i*w;
end;
if nargin < 12,
  s1 = 1;
end;
if nargin < 11,
  r1 = 1;
end;
% To get stationary gain = 1 from r to y
bm = bm/bm(length(bm)).*am(length(am)); 
g = polyval(b,z)./polyval(a,z).*exp(-tau*z);
gm = polyval(bm,z)./polyval(am,z).*exp(-taum*z);
[r,s,t,the_error]=rstfit(z,g,gm,ao,nr,ns,r1,s1,weighting);
