function [r,s,t,ecl,eol]=rstfit1(z,g,gcl,gol,ao,nr,ns,r1,s1,weighting)
% RSTFIT1 Finds a controller for which for the given
%       plant frequency response approximately gives
%       open loop  and closed loop frequency responses
%       according to specifications at given frequencies.
%
%       [R,S,T,ECL,EOL]=RSTFIT1(Z,G,GCL,GOL,AO,NR,NS,R1,S1,WEIGHTING)
%
%       The complex frequency response G, given at the
%       complex frequencies Z, is used for least squares fitting
%       of controller parameters in the controller structure
%       Ru = Tr - Sy. The closed loop system (r --> y) is specified
%       by the frequency response GCL, given at the
%       length(GCL) first frequencies of Z.
%       The open loop frequency response is specified by GOL
%       at the length(GOL) last frequencies of Z.
%       Factors to be included in R are specified by the polynomial R1.
%       Similarly, S1 pre-specifies factors of S.
%       Deg R = NR and deg S = NS. The observer polynomial is given by
%       AO (T = const.*AO). Default WEIGHTING is unity weighting
%       while R1 and S1 both defaults to 1.
%       The magnitude of the (weighted) closed loop transfer
%       function error is given by ECL and the open loop
%       transfer function error by EOL.

% Mats Lilja
% LastEditDate : Wed Apr 15 13:20:00 1992
% Copyright (c) 1991 by Mats Lilja and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

nz = length(z);
ng = length(g);
ngcl = length(gcl);
ngol = length(gol);
if nz ~= ng,
  error('Different lengths of vectors Z and G');
end;
if nz ~= ngol + ngcl
  error('Different lengths of vectors Z and [GCL GOL]');
end;
if nargin < 10,
  weighting = ones(1,nz);
end;
if nargin < 9,
  s1 = 1;
end;
if nargin < 8,
  r1 = 1;
end;
nweight = length(weighting);
if nweight == 0,
  weighting = ones(1,nz);
elseif nweight ~= nz
  error('Wrong number of weightings');
end;
zcl = z(1:ngcl);
zol = z((1:ngol)+ngcl);
nr2 = nr - length(r1) + 1;
if nr2 < 0,
  error('Degree of R1 higher than degree of R');
end;
ns2 = ns - length(s1) + 1;
if ns2 < 0,
  error('Degree of S1 higher than degree of S');
end;
i = sqrt(-1);
f = abs(weighting);
Npoints = 2*nz;
Nparameters = nr2 + ns2 + 2;
%%%%
if Npoints < Nparameters
  error('Too few approximation points.');
end;
f1 = f(1:ngcl);
f2 = f((1:ngol)+ngcl);
aovec = polyval(ao,zcl);
gr = f1.*polyval(r1,zcl).*gcl./aovec./g(1:ngcl);
gs = f1.*polyval(s1,zcl).*gcl./aovec;
grl = f2.*polyval(r1,zol).*gol./g((1:ngol)+ngcl);
gsl = -f2.*polyval(s1,zol);
one = ones(1,nz);
ms = one;
zs = one;
for j=1:ns2,
  zs = z.*zs;
  ms = [zs ; ms];
end;
mr = one;
zr = one;
for j=1:nr2,
  zr = z.*zr;
  mr = [zr ; mr];
end;
l = [f1(:) ; 0*f2(:)].';
m = [mr*diag([gr grl])  ; ms*diag([gs gsl])];
mm = [real(m) imag(m)];
ll = [real(l) imag(l)];
x = ll/mm;
t0 = 1/x(1);
r2 = [1 t0*x(2:nr2+1)];
r = conv(r1,r2);
s2 = t0*x(nr2+2:nr2+ns2+2);
s = conv(s1,s2);
t = t0*ao;
num = g(1:ngcl).*polyval(t,zcl);
den = polyval(r,zcl) + g(1:ngcl).*polyval(s,zcl);
ecl = abs(num./den - gcl);
eol = abs(g((1:ngol)+ngcl).*polyval(s,zol)./polyval(r,zol)-gol);

