function [R,S,T] = pid2rstd(tsamp,K,Ti,Td,N,beta,betad,dmethod)
% [R,S,T] = pid2rst(tsamp,K,Ti,Td,N,beta,betad,dmethod)
%
%   dmethod = 'euler' or 'zoh'
%
if nargin < 8
  dmethod = 'euler';
end;
if (nargin == 2) | (nargin == 3)
  [nrow,ncol] = size(K);
  if ncol < 6,
    error('Too few parameters');
  end;
  pidpar = K;
  betad = pidpar(:,6);
  beta = pidpar(:,5);
  N = pidpar(:,4);
  Td = pidpar(:,3);
  Ti = pidpar(:,2);
  K = pidpar(:,1);
  if nargin == 2
    dmethod = 'euler';
  end;
end;
K = K(:);
Ti = Ti(:);
Td = Td(:);
N = N(:);
beta = beta(:);
betad = betad(:);
[K,Ti,Td,N,beta,betad];
if any(Td < 0),
  svar=input('Td < 0 --- Change sign of the derivative filter factor N? ','s');
  if svar(1) == 'y'
    N = sign(Td).*N;
  end;
end;
one = K.^0;
h = tsamp*one;
if dmethod(1:3) == 'zoh'
  c = exp(-h.*N./Td);
  b = N;
else
  c = Td./(Td+h.*N);  
  b = N.*c;
end;
r1 = -(1+c)*one;
r2 = c;
s0 = K.*(b+one);
s1 = K.*(h./Ti-2*b-c-one);
s2 = K.*(b+c.*(one-h./Ti));
t0 = K.*(betad.*b+beta);
t1 = K.*(h./Ti-2*betad.*b-beta.*(one+c));
t2 = K.*(betad.*b+c.*(beta-h./Ti));
R = [1 r1 r2];
S = [s0 s1 s2];
T = [t0 t1 t2];

