function [K,Ti,Td,N,beta,betad] = rst2pid(rpol,spol,tpol,toler);
% [K,Ti,Td,N,beta,betad] = rst2pid(rpol,spol,tpol)
if nargin < 4,
  toler = 1e-3;
elseif nargin < 3,
  error('Too few input arguments');
end;
r = rpol/rpol(1);
s = spol/rpol(1);
t = tpol/rpol(1);
r1 = r(2);
r2 = r(3);
if abs(r2)>1e-12;
  error('R-polynomial must have a zero in 0');
end;
s0 = s(1);
s1 = s(2);
s2 = s(3);
t0 = t(1);
t1 = t(2);
t2 = t(3);
test = abs((t2-s2)/s2);
if test > toler,
  disp('Zero degree coefficients must coincide in polynomials S and T.');
  disp('Normalizing the polynomial T.')  ;
  t = t/t(length(t))*s(length(s));
end;
Ti = s1/s2 - 1/r1;
K = s2*Ti/r1;
N = s0/K - 1;
Td = N/r1;
Tir = t1/t2 - 1/r1;
Kr = t2*Tir/r1;
Nr = t0/Kr - 1;
Tdr = Nr/r1;
beta = Kr/K;
betad = beta*Tdr/Td;
