function [polystring] = fpolystr(p,letter,ndigits);
% fpolystr(p,letter,ndigits)
p0 = p(1);
if nargin < 3,
  ndigits = 4;
end;
if nargin < 2,
  letter = 's';
end;
r = roots(p);
n = length(r);
[xx,ii] = sort(abs(imag(r)));
r = r(ii);
cind = min(find(abs(imag(r))>0));
if length(cind) > 0,
  rr = r(1:cind-1);
else,
  rr = r;
end;
cr = r(cind:n);
if p0 ~= 1,
  polystring = sprintf('%g',p0);
else,
  polystring = '';
end;
ii = find(abs(rr)==0);
if length(ii) > 0,
  polystring = [polystring polystr(eye(1,length(ii)+1),letter,ndigits)];
  rr(ii) = [];
end;
for j=1:length(rr),
  q = poly(rr(j));
  polystring = [polystring '(' polystr(q,letter,ndigits) ')'];
end;
for j=1:2:length(cr),
  q = poly(cr([j j+1]));
  polystring = [polystring '(' polystr(q,letter,ndigits) ')'];
end;
