function p = lqpoly(b,a,rho);
% p = lqpoly(b,a,rho);
% Generates the monic polynomial with zeros at the stable
% roots of
%
%      a(s)a(-s) +- (1/rho) b(s)b(-s) = 0
%
% where the sign is chosen so that no roots are located on
% the imaginary axis.
if nargin ~= 3,
  error('Wrong number of arguments. Use "p = lqpoly(b,a,rho)"!');
end;
na = length(a);
nb = length(b);
a_ = a.*(-1).^((1:na)-na);
b_ = b.*(-1).^((1:nb)-nb);
aa = conv(a,a_);
bb = conv(b,b_);
rpp = roots(addpoly(aa,bb/rho));
p = real(poly(rpp(find(real(rpp)<0))));
