function [static_gain,Tr,Ts,M,T,L,T63]=srespana(ty,Tr_Lev,Ts_bound,T_L_Lev)
%
    % [k,Tr,Ts,M,T,L,T63] = srespana(ty,[Tr_Lev1 Tr_Lev2],Ts_bound,[T_L_Lev1 T_L_Lev2])
%
T_L_Lev_default = [0.2 0.8];
Ts_bound_default = 0.05;
Tr_Lev_default = [0.1 0.9];
if nargin < 4
  T_L_Lev = T_L_Lev_default;
end
if nargin < 3
  Ts_bound = Ts_bound_default;
end
if nargin < 2
  Tr_Lev = Tr_Lev_default;
end
if length(T_L_Lev)==0
  T_L_Lev = T_L_Lev_default;
end
if length(Ts_bound)==0
  Ts_bound = Ts_bound_default;
end
if length(Tr_Lev)==0
  Tr_Lev = Tr_Lev_default;
end
t = ty(:,1);
y = ty(:,2);
static_gain = y(length(y));
yn = y/static_gain;
ymax = max(yn);
M = (ymax-1);
%
Tr_ind1 = min(find(yn > Tr_Lev(1))) - 1;
Tr_ind2 = min(find(yn > Tr_Lev(2))) - 1;
t0= t(Tr_ind1); t1= t(Tr_ind1+1);
y0=yn(Tr_ind1); y1=yn(Tr_ind1+1);
Tr1 = t0 + (Tr_Lev(1)-y0)*(t1-t0)/(y1-y0);
t0= t(Tr_ind2); t1= t(Tr_ind2+1);
y0=yn(Tr_ind2); y1=yn(Tr_ind2+1);
Tr2 = t0 + (Tr_Lev(2)-y0)*(t1-t0)/(y1-y0);
Tr = Tr2 - Tr1;
%
e_abs = abs(yn-1);
Ts_ind = max(find(e_abs>Ts_bound));
t0= t(Ts_ind); t1= t(Ts_ind+1);
y0=e_abs(Ts_ind); y1=e_abs(Ts_ind+1);
Ts = t0 + (Ts_bound-y0)*(t1-t0)/(y1-y0);
%
T_L_ind1 = min(find(yn > T_L_Lev(1))) - 1;
T_L_ind2 = min(find(yn > T_L_Lev(2))) - 1;
t0= t(T_L_ind1); t1= t(T_L_ind1+1);
y0=yn(T_L_ind1); y1=yn(T_L_ind1+1);
T_L1 = t0 + (T_L_Lev(1)-y0)*(t1-t0)/(y1-y0);
t0= t(T_L_ind2); t1= t(T_L_ind2+1);
y0=yn(T_L_ind2); y1=yn(T_L_ind2+1);
T_L2 = t0 + (T_L_Lev(2)-y0)*(t1-t0)/(y1-y0);
T = (T_L2 - T_L1)/(log(1-T_L_Lev(1))-log(1-T_L_Lev(2)));
L = T_L1 + T*log(1-T_L_Lev(1));
Tp_ind = min(find(yn > 1-exp(-1))) - 1;
t0= t(Tp_ind); t1= t(Tp_ind+1);
y0=yn(Tp_ind); y1=yn(Tp_ind+1);
T63 = t0 + (1-exp(-1)-y0)*(t1-t0)/(y1-y0);

