function yupl(tr1,tr2,tr3,tr4,scale)
% YUPL  Plot time responses.
%
%       YUPL(TR1,TR2,TR3,TR4,SCALE)
%
%       A plot of simulation results TR1 - TR4 from YUSIMC or YUSIMD is
%       done.  The arguments TR2 - TR4 are optional. TR1 - TR4 are
%       allowed to have different number of data points.
%
%	The optional argument SCALE is used to affect the scaling of the 
%       plot. It takes the form [tmin tmax ymin ymax umin umax].
%       SCALE can be used even if TR2 - TR4 are omitted.
%
%       The scales are stored in the variable glob_scale, which must be
%       declared as global. The scales are used to be able to draw 
%       consecutive plots (using YUSH) in the same diagram.

% Michael Lundh     LastEditDate : Tue Jun 18 08:33:48 1991
% Copyright (c) 1990 by Michael Lundh and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%%%if ppcheck, return, end
global glob_hz;
global glob_scale;
 
if nargin==4,
  scale = tr4;
elseif nargin==3,
  scale = tr3;
elseif nargin==2,
  scale = tr2;
elseif nargin==1,
  scale = [];
end

if size(scale) == [1 6],
  npl = nargin-1;
  yscale = scale(1,1:4);
  uscale = scale(1,[1,2,5,6]);
else
  npl = nargin;
  yscale = [];
  uscale = [];
end  

[m,n]=size(tr1);
t1=tr1(:,1);  r1=tr1(:,2);  y1=tr1(:,3:2+(n-2)/2);  u1=tr1(:,3+(n-2)/2:n);
do1='plot(t1,y1,t1,r1,''-c'' ';
do2='plot(t1,u1';

if npl>1
  [m,n]=size(tr2);
  t2=tr2(:,1);  r2=tr2(:,2);  y2=tr2(:,3:2+(n-2)/2);  u2=tr2(:,3+(n-2)/2:n);
  do1=[do1 ',t2,y2,t2,r2,''-c'' '];
  do2=[do2 ',t2,u2'];
end
if npl>2
   [m,n]=size(tr3);
  t3=tr3(:,1);  r3=tr3(:,2);  y3=tr3(:,3:2+(n-2)/2);  u3=tr3(:,3+(n-2)/2:n);
  do1=[do1 ',t3,y3,t3,r3,''-c'' '];
  do2=[do2 ',t3,u3'];
end
if npl>3
  [m,n]=size(tr4);
  t4=tr4(:,1);  r4=tr4(:,2);  y4=tr4(:,3:2+(n-2)/2);  u4=tr4(:,3+(n-2)/2:n);
  do1=[do1 ',t4,y4,t4,r4,''-c'' '];
  do2=[do2 ',t4,u4'];
end

do1=[do1 ')'];
do2=[do2 ')'];

clf
subplot;
subplot(211);
axis([0 1 0 1]);axis; % autorange axis
if length(yscale)>0, axis(yscale); end;
eval(do1);
ylabel('r and y');
%%%text(0.83,0.61,'time [s]','sc')
xlabel('time [s]')
%%%
glob_scale = axis;
axis(glob_scale);
axis;

subplot(212);
if length(uscale)>0, axis(uscale); end;
eval(do2);
ylabel('u')
%%%text(0.83,0.11,'time [s]','sc')
xlabel('time [s]');
%%%
glob_scale = [glob_scale ;axis];
axis(glob_scale(2,:));
axis;

subplot(211);
