function mark(pos,mtype,msize,mindex,aspect)
% MARK 	plot and index markings
%
%	mark(pos,mtype,msize,mindex,aspect)
%
%       A marking of type mtype is made at position pos with size msize. The
%	marking is superindexed with the numerical value in mindex. If pos is 
%       a vector then mtype, msize, and/or mindex can be supplied as scalars 
%	or vectors. If they are scalars the same type (size, index) is used for
%	all values in pos. Otherwise mtype(i), msize(i), and mindex(i) are used
%	for pos(i).
%
%       mtype, msize, and mindex are all optional. If omitted they default to
% 	1, 0.01, and NaN, respectively. NaN at any position in mindex omits
%	indexing at the corresponding point. Parameters inside the parameter
%	list are omitted by supplying an empty matrix, i.e. [].
%
%	Possible mark types are
%
%	1  plus         4  ring          7  hollow plus      10  natostar
%       2  cross        5  heart         8  smiley face
%       3  diamond      6  triangle      9  pentagon
%
%       aspect is an optional argument telling the aspect ratio of the screen.
%	Default value is 137/99 (the normal screen). aspect = 1 should be used
%	with axis('square').
%
%       hold will be off after having executed this routine.

% Per Persson (original routine plopp)
% Kjell Gustafsson (revised version)
% LastEditDate : Wed Sep  5 14:06:00 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin<5, aspect = 137/99; end
if nargin<4, mindex = NaN; end
if nargin<3, msize = 0.01; end
if nargin<2, mtype = 1; end

if size(mtype)==[0 0], mtype = 1; end
if size(msize)==[0 0], msize = 0.01; end
if size(mindex)==[0 0], mindex = NaN; end

lpos = length(pos);
if lpos>1
  if length(mtype)==1, mtype = mtype*ones(1,lpos); end
  if length(msize)==1, msize = msize*ones(1,lpos); end
  if length(mindex)==1, mindex = mindex*ones(1,lpos); end
end

i = sqrt(-1);
ax = axis;
axis;

for ipos=1:lpos
  dx = msize(ipos)*(ax(2) - ax(1))/aspect;
  dy = msize(ipos)*(ax(4) - ax(3));
  x = real(pos(ipos)); 
  y = imag(pos(ipos)); 
  hold on;
  dx1 = 5*dx; dy1 = 5*dy;
  if (x-dx1 > ax(1)) & (x+dx1 < ax(2)) & (y-dy1 > ax(3)) & (y+dy1 < ax(4)),
    if mtype(ipos) == 1,
      plot([(x - dx), (x + dx)], [y, y]);
      plot([x, x], [(y - dy), (y + dy)]);
    elseif mtype(ipos) == 2,
      sc = sqrt(0.5); dx1 = sc*dx; dy1 = sc*dy;
      plot([(x - dx1), (x + dx1)], [(y - dy1), (y + dy1)]);
      plot([(x - dx1), (x + dx1)], [(y + dy1), (y - dy1)]);
    elseif mtype(ipos) == 3,
      sc = sqrt(0.5); dx1 = sc*dx; dy1 = sc*dy;
      plot([(x - dx1) x], [y (y + dy1)]);
      plot([x (x + dx1)], [(y + dy1) y]);
      plot([(x - dx1) x], [y (y - dy1)]);
      plot([x (x + dx1)], [(y - dy1) y]);
    elseif mtype(ipos) == 4, 
      tmp = [0:2*pi/20:2*pi]';
      res = sqrt(0.5)*[dx*cos(tmp) dy*sin(tmp)];
      plot(res(:, 1) + x, res(:, 2) + y);
    elseif mtype(ipos) == 5,
      dx1 = 1.5*dx; dy1 = 1.5*dy;
      tmp1 = [-pi/4:pi/20:3*pi/4]';
      tmp2 = [pi/4:pi/20:5*pi/4]';
      res1 = [dx1*cos(tmp1) dy1*sin(tmp1)]/sqrt(8);
      res2 = [dx1*cos(tmp2) dy1*sin(tmp2)]/sqrt(8);
      plot(res1(:, 1) + x + dx1/4, res1(:, 2) + y + dy1/4);
      plot(res2(:, 1) + x - dx1/4, res2(:, 2) + y + dy1/4);
      plot((dx1*[0 0.5] + x), (dy1*[-0.5 0] + y));
      plot((dx1*[-0.5 0] + x), (dy1*[0 -0.5] + y));
    elseif mtype(ipos) == 6,
      tmp = [0:2*pi/3:2*pi]';
      res = sqrt(0.5)*[dx*cos(tmp) dy*sin(tmp)];
      plot(res(:, 1) + x, res(:, 2) + y);
    elseif mtype(ipos) == 7,
      m1 = [(x-dx) (x-dx/4) (x-dx/4) (x+dx/4) (x+dx/4),...
	    (x+dx) (x+dx) (x+dx/4) (x+dx/4) (x-dx/4) (x-dx/4) (x-dx) (x-dx)];
      m2 = [(y+dy/4) (y+dy/4) (y+dy) (y+dy) (y+dy/4) (y+dy/4),...
	    (y-dy/4) (y-dy/4) (y-dy) (y-dy) (y-dy/4) (y-dy/4) (y+dy/4)];    
      plot(m1, m2);
    elseif mtype(ipos) == 8,
      tmp = [0:2*pi/20:2*pi]';
      c = [dx*cos(tmp) dy*sin(tmp)];
      res = 1.5*c;
      plot(res(:, 1) + x, res(:, 2) + y);
      res = 0.2*c;
      plot(res(:, 1) + x - 0.6*dx, res(:, 2) + y + 0.5*dy);
      plot(res(:, 1) + x + 0.6*dx, res(:, 2) + y + 0.5*dy);
      tmp = [pi*1.1:2*pi/50:1.9*pi]';
      c = [dx*cos(tmp) dy*sin(tmp)];
      res = 0.9*c;
      plot(res(:, 1) + x, res(:, 2) + y - 0.2*dy);
    elseif mtype(ipos) == 9,
      tmp = [0:2*pi/5:2*pi]';
      res = sqrt(0.5)*[dx*cos(tmp) dy*sin(tmp)];
      plot(res(:, 1) + x, res(:, 2) + y);
    elseif mtype(ipos) == 10,
      plot([0, dx/4, dx, dx/4, 0, -dx/4, -dx, -dx/4, 0] + x,...
	   [dy, dy/4, 0, -dy/4, -dy, -dy/4, 0, dy/4, dy] + y);
    end;
  end;
  hold off;
  if mindex(ipos) ~= NaN
    numbers(mindex(ipos), x + dx + i*(y + dy));
  end;
end;
