function pzgrid(disc)
% PZGRID draw grid in pole-zero plot
%
%	pzgrid(disc)
%
%	If the (optional) argument disc is supplied a unit circle will be 
%	drawn. When plotting the circle Matlab prints a warning. Don't mind!
%
%	The Matlab function zgrid might be useful when plotting discrete-time
%	poles and zeros.

% Kjell Gustafsson
% LastEditDate : Fri Jun  8 13:53:56 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

%axis('square');
hold on;
grid
if nargin==1
  uc = exp(sqrt(-1)*(0:pi/50:2*pi));
  plot([uc; uc([2:101,2])],'-c');         % unit circle
else
%  plot([-1E10; 1E10],[0; 0],'-c');        % real axis
%  plot([0; 0],[-1E10; 1E10],'-c');        % imaginary axis
end
hold off
%axis('normal');
