function pzsh(b,a,pmark,zmark,msize)
% PZSH	add to a previous pole-zero plot
%
%	pzsh(b,a,pmark,zmark,msize)
%	pzsh(b,a,pmark,zmark)
%	pzsh(b,a)
%
%	Plots the poles and zeros of the transfer function b(s)/a(s). Poles
% 	and zeros are marked with mark type pmark and zmark, respectively. 
%	Possible mark types are
%
%	1  plus         4  ring          7  hollow plus      10  natostar
%       2  cross        5  heart         8  smiley face
%       3  diamond      6  triangle      9  pentagon
%
%	If pmark and/or zmark are omitted or supplied as [] they default to 
%	2 (cross) and 4 (ring). The marks have the size msize which defaults 
%       to 0.01 if msize is omitted or supplied as [].

% Kjell Gustafsson
% LastEditDate : Thu Jul  5 15:02:37 1990
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

if nargin<3, pmark = 2; end
if nargin<4, zmark = 4; end
if nargin<5, msize = 0.01; end

if size(pmark)==[0 0], pmark = 2; end
if size(zmark)==[0 0], zmark = 4; end
if size(msize)==[0 0], msize = 0.01; end

axis('square');
mark(roots(b),zmark,msize,[],1);
mark(roots(a),pmark,msize,[],1);
axis('normal');
