% Kjell Gustafsson
% LastEditDate : Thu May 30 09:18:15 1991
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

echo on
clc
%	This example demonstrates some of the functions in RLBOX

% 	Consider the continuous time system b(s)/a(s) where

b = poly(-4)
a = poly([0 -2 -6])

pause  	% Strike RETURN to get a pole-zero plot

pzpl(b,a)
title('Pole-zero plot of the system b(s)/a(s)'); pause

pause   % Strike RETURN to add a grid

pzgrid, pause

clc
%	Let's use a proportional controller to control the system. 
%	The variation of the closed loop poles can be seen in a root 
%	locus plot. RLOC1 plots the root locus including start and end
%	points.

pause 	% Strike RETURN for a plot of the full root locus

rloc1(b,a,0.01,40,0.2);
title('Root locus of the system b(s)/a(s)'),  pause

clc
%	Suppose we are interested in the pole positions for gain variations 
%	around the nominal value knom = 2. RLOC2 can be used to plot just
% 	a part of the root locus.

 	% Strike RETURN for a plot of the root locus for k = 1..4 with
pause	% the nominal value knom marked.

rloc2(b,a,1,2,4,0.2);
title('Root locus of b(s)/a(s) around the nominal point k = 2'), pause

clc
%	When designing continuous time LQ controllers it is interesting to
%	see the pole variations as function of rho when using the cost 
%	function J = integ( y^2 + rho u^2 ). This can be achieved using
%	SYMLOC.

pause 	% Strike RETURN for a plot of the continuous time rho root locus

symlocc(b,a,0.01,10000,0.4);
title('Symmetric rho root locus for b(s)/a(s)'), pause

clc
%	There is a corresponding discrete time symmetric rho root locus. It
% 	can be plotted using DSYMLOC. As discrete system we will use the
%	sampled double integrator (CCS Example 11.2)

bd = poly(-1)
ad = poly([1 1])

pause 	% Strike RETURN for a plot of the discrete time rho root locus

symlocd(bd,ad,1e-4,1e4,0.07);
title('Symmetric rho root locus for bd(z)/ad(z)'), pause

pause   % Strike RETURN to add grid and unit circle
pzgrid(1), pause

pause	% Strike RETURN to end

echo off
