function locus = rloc2(b,a,k1,knom,k2,dsmax,scale);
% RLOC2	Plots root locus around a nominal point.
%
%	locus = rloc2(b,a,k1,knom,k2,dsmax,scale)
%	locus = rloc2(b,a,k1,knom,k2,dsmax)
%
%	Plots the root locus of a(s) + k*b(s) for k1 < k < k2. The nominal
%       roots corresponding to knom are marked with a *.
%
%       The increments in k are chosen such that abs(ds) < dsmax.
%       The k-values and the roots are stored in locus, with the k-values
%       in the first column.
%
%	scale (optional) takes the form [xmax xmin ymin ymax]. If scale is 
%	omitted an attempt is done to find a plot scale that gives an aspect
%	ratio as close to 1 as possible.

% Kjell Gustafsson, derived from routines by Mats Lilja
% LastEditDate : Thu May 30 09:13:57 1991
% Copyright (c) 1990 by Kjell Gustafsson and Department of Automatic Control,
% Lund Institute of Technology, Lund, SWEDEN

locus = rootloc(b,a,k1,k2,dsmax);
reldeg = length(a) - length(b);
if reldeg>=0,
  b = [0*(1:reldeg) b];
else
  a = [0*(1:-reldeg) a];
end
index = sum(locus(:,1)<knom);
locus = [locus(1:index,:); [knom roots(a+knom*b)'];..
  locus(index+1:length(locus(:,1)),:)];
rl = locus(:,2:size(locus)*[0;1]);

if nargin<7
  Re_max = max(max(real(rl)));
  Re_min = min(min(real(rl)));
  Im_max = max(max(imag(rl)));
  dRe = Re_max - Re_min;
  dIm = 2*Im_max;
  mRe = (Re_min + Re_max)/2;
  d = max(dRe,dIm);
  if d==0
    w = [-abs(Re_max) abs(Re_max)]*1.2;
  else
    w = [-d/2 d/2]*1.2;
  end
  scale = [w+mRe w];
end

axis('square');
axis(scale);
plot(0,0,'i');
hold on;
plot(real(rl),imag(rl),'.w')
mark(rl(index+1,:),2,[],[],1);
xlabel('Re');
ylabel('Im');
hold off;
axis('normal');
